/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class Canvas extends Composite {
	Caret caret;
	IME ime;

Canvas () {
}
	
public Canvas (Composite parent, int style) {
	super (parent, style);
}

public Caret getCaret () {
	return null;
}

public IME getIME () {
	checkWidget();
    return ime;
}

public void drawBackground (GC gc, int x, int y, int width, int height) {
}

public void scroll (int destX, int destY, int x, int y, int width, int height, boolean all) {
}

void releaseChildren (boolean destroy) {
	if (caret != null) {
		caret.release (false);
		caret = null;
	}
	super.releaseChildren (destroy);
}

public void setCaret (Caret caret) {
}

public void setFont (Font font) {
}

public void setIME (IME ime) {
	checkWidget ();
	if (ime != null && ime.isDisposed()) error(SWT.ERROR_INVALID_ARGUMENT);
	this.ime = ime;
}

}
